/*
 *  MoreSecurityAsync.h
 *  TestAuthTool
 *
 *  Created by Brian Wells on 12/4/05.
 *  Copyright 2005 Brian D. Wells. All rights reserved.
 *
 *  You may redistribute this software and/or modify it under
 *  the terms set forth in the accompanying LICENSE file.
 *
 */

#pragma once

// MoreIsBetter setup

#include "MoreSetup.h"
#include "MoreSecurity.h"
#include "MoreUNIX.h"
#include "MoreCFQ.h"

// System prototypes

#include <poll.h>

/////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

/////////////////////////////////////////////////////////////////
#pragma mark ***** Asynchronous Usage Functions

extern OSStatus MoreSecAsyncExecuteRequestInHelperTool(CFURLRef helperTool, AuthorizationRef auth, 
											 	  CFDictionaryRef request, int *fdPipe, int *childPID);
	// Just like MoreSecExecuteRequestInHelperTool, executes a privileged request in a helper tool.
	// The big difference is that this function does not read the response back from the tool or
	// wait for it to exit. Instead, follow up a call to this function with repeated calls to the
	// MoreSecAsyncGetHelperToolResponse function, passing fdPipe and childPID.
	//
	// helperTool must not be NULL
	// auth must not be NULL
	// request must not be NULL
	// fdPipe must not be NULL; on success, *fdPipe will be handle to socket for tool; on error, *fdPipe will be -1
	// childPID must not be NULL; on success, *childPID will be process ID of tool; on error, *childPID will be -1

extern OSStatus MoreSecAsyncGetHelperToolResponse(int fdPipe, int childPID, CFDictionaryRef *response, Boolean *isFinalResponse);
	// Counterpart to MoreSecAsyncExecuteRequestInHelperTool. Polls tool's socket handle for a pending response
	// using the MoreUNIXPoll function.
	//
	// fdPipe must not be less than 1
	// childPID must not be 0
	// response must not be NULL; *response must be NULL;
	//   on success, *response will be a dictionary containing at least the kMoreSecErrorNumberKey key; it will
	//     also contain the kMoreSecAsyncIdentifierKey key if additional responses are to be expected from the tool
	//   on error, *response will be NULL
	// isFinalResponse must not be NULL; *isFinalResponse must be false;
	//   on success, *isFinalResponse will be true if *response contains the kMoreSecAsyncIdentifierKey key
	//   on error, *isFinalResponse will also be true
	
/*
extern OSStatus MoreSecAsyncAbortHelperToolRequest(int fdPipe, int childPID);
	// was planning to have a function that could SIGKILL the tool, but it is rather hard to kill a privileged
	// process from an unprivileged process. If anyone feels like implementing something, let me know :-)
*/

extern OSStatus MoreSecAsyncHelperToolWriteResponse(CFDictionaryRef dict, int fdOut);
	// This function is for the tool to write multiple responses into the pipe.
	// All it does is add the kMoreSecAsyncIdentifierKey key ro the response so that
	// MoreSecAsyncGetHelperToolResponse knows that more responses should be expected.
	//
	// dict must not be NULL; should be a dictionary suitable for passing to WriteDictionaryAndDescriptors
	// fdOut must not be less than 1; should be STDOUT_FILENO, since this is what is typically passed to
	// MoreSecHelperToolMain for its fdOut parameter
	
#define kMoreSecAsyncIdentifierKey CFSTR("com.apple.dts.MoreIsBetter.MoreSec.AsyncID")		// CFNumberRef, 1
	// The dictionary key that indicates that this response is not expected to be the final response.


/////////////////////////////////////////////////////////////////
#pragma mark ***** UNIX Support Functions

// MoreUNIX addition to support polling tool socket

extern int MoreUNIXPoll(int fd, short events, short *revents, int timeout);
	// Wrapper around poll(2) to determine if file descriptor is ready for I/O.
	//
	// fd must be non-negative and non-zero; fd is the file descriptor to poll
	// events is a bitmask indicating which events to poll for; typically POLLIN
	// revents must not be NULL; on success, *revents will indicate which events
	// occured; on error, *revents should be 0;
	// timeout specifies the maximum blocking interval in milliseconds; 0 indicates
	// no blocking, while -1 indicates indefinite blocking.
	//
	// see the poll(2) man page for more details on the event bitmasks


#ifdef __cplusplus
}
#endif
