//
//  TestAuthToolController.h
//  TestAuthTool
//
//  Created by Brian Wells on 11/21/05.
//  Copyright 2005 Brian D. Wells. All rights reserved.
//
//  You may redistribute this software and/or modify it under
//  the terms set forth in the accompanying LICENSE file.
//

#import <Cocoa/Cocoa.h>

#include "TestAuthToolCommon.h"

// MoreIsBetter interfaces

#include "MoreUNIX.h"
#include "MoreSecurity.h"
#include "MoreCFQ.h"
#include "MoreSecurityAsync.h"

@interface TestAuthToolController : NSObject
{
    IBOutlet NSButton *activateButton;
    IBOutlet NSButton *checkButton;
    IBOutlet NSTextField *euidField;
    IBOutlet NSTextField *ruidField;
    IBOutlet NSTextField *suidField;
    IBOutlet NSButton *testButton;
    IBOutlet NSTextField *testInputField;
    IBOutlet NSTextView *testResultView;
	IBOutlet NSButton *testAsnycButton;

	AuthorizationRef auth;
	NSURL *tool;
	
	int fdPipe;
	int childPID;
	NSTimer *timer;
	BOOL isRunningTest;
}
- (IBAction)activateTool:(id)sender;
- (IBAction)checkUIDs:(id)sender;
- (IBAction)runTest:(id)sender;

@end
